clear
set more off
set mem 50000
set matsize 700
version 10
cd "C:\Users\Andrew\My publications\Rational voters\"

/*

use "Van Belle.dta", clear
reshape long year, i(countryc) j(y)  
ren year pfreedom
ren y year
la var pfreedom "Press freedom - Van Belle"
recode pfreedom 0=. 8/max=.
sort countryc year
save "Van Belle-sorted.dta", replace

* Converting WDI extract into a mergeable format
use wdi.extract.jan2004.dta, clear
ren countrycode cty
drop countryname seriesname
save temp0.dta, replace
use temp0.dta, clear
keep if seriescode=="IT.PRT.NEWS.P3" 
drop series
for num 1960/2000: ren yearX papersX
reshape long papers, i(cty) j(year)  
la var papers "Daily newspapers (per 1,000 people), Source: WDI"
sort cty year
save temp1.dta, replace
use temp0.dta, clear
keep if seriescode=="IT.RAD.SETS.P3" 
drop series
for num 1960/2000: ren yearX radiosX
reshape long radios, i(cty) j(year)  
la var radios "Radios (per 1,000 people), Source: WDI"
sort cty year
save temp2.dta, replace
use temp0.dta, clear
keep if seriescode=="IT.MLT.MAIN.P3" 
drop series
for num 1960/2000: ren yearX phonesX
reshape long phones, i(cty) j(year)  
la var phones "Telephone mainlines (per 1,000 people), Source: WDI"
sort cty year
save temp3.dta, replace
use temp0.dta, clear
keep if seriescode=="IT.TVS.SETS.P3" 
drop series
for num 1960/2000: ren yearX tvsX
reshape long tvs, i(cty) j(year)  
la var tvs "Television sets (per 1,000 people), Source: WDI"
sort cty year
save temp4.dta, replace

use temp0.dta, clear
keep if seriescode=="NY.GDP.PCAP.KD.ZG" 
drop series
for num 1960/2000: ren yearX dyX
reshape long dy, i(cty) j(year)  
gen temp1=dy if cty=="WLD"
bysort year: egen dyworld=max(temp1)
gen temp2=dy if cty=="OEC"
bysort year: egen dyoecd=max(temp2)
drop if cty=="WLD" | cty=="OEC"
drop temp*
la var dyworld "World GDP per capita growth (annual %), Source: WDI"
la var dyoecd "OECD GDP per capita growth (annual %), Source: WDI"
la var dy "National GDP per capita growth (annual %), Source: WDI"
sort cty year
save temp5.dta, replace

use temp0.dta, clear
keep if seriescode=="SE.ADT.ILIT.ZS" 
drop series
for num 1960/2000: ren yearX illiteracyX
reshape long illiteracy, i(cty) j(year)  
la var illiteracy "Illiteracy rate, Source: WDI"
sort cty year
save temp6.dta, replace

use temp0.dta, clear
keep if seriescode=="IS.VEH.NVEH.P3" 
drop series
for num 1960/2000: ren yearX vehiclesX
reshape long vehicles, i(cty) j(year)  
la var vehicles "Vehicles (per 1000 people), Source: WDI"
sort cty year
save temp7.dta, replace
use temp0.dta, clear
keep if seriescode=="NY.GDP.PCAP.KD" 
drop series
for num 1960/2000: ren yearX gdpX
reshape long gdp, i(cty) j(year)  
la var gdp "GDP per capita (1995 US$), Source: WDI"
sort cty year
save temp8.dta, replace

use temp0.dta, clear
keep if seriescode=="IT.CMP.PCMP.P3" 
drop series
for num 1960/2000: ren yearX computersX
reshape long computers, i(cty) j(year)  
la var computers "Personal computers (per 1000 people), Source: WDI"
sort cty year
save temp9.dta, replace

use temp0.dta, clear
keep if seriescode=="IS.VEH.PCAR.P3" 
drop series
for num 1960/2000: ren yearX carsX
reshape long cars, i(cty) j(year)  
la var cars "Passenger cars (per 1000 people), Source: WDI"
sort cty year
save temp10.dta, replace

use temp0.dta, clear
keep if seriescode=="SP.POP.TOTL" 
drop series
for num 1960/2000: ren yearX populationX
reshape long population, i(cty) j(year)  
la var population "Population, Source: WDI"
sort cty year
save temp11.dta, replace

* Barro-Lee education data
use barro-lee.1960_2000.dta, clear
sort shcode
merge shcode using barro-lee.to.wdi.crosswalk.ctycodes.dta
drop if _merge~=3
keep cty tyr15*
reshape long tyr15, i(cty) j(year)
replace year=year+1900
recode year 1999=2000
la var tyr15 "Average years of schooling of the adult population. Source: Barro-Lee"
sort cty year
save temp12.dta, replace

* Govt share data
use "wdi.govtshare.dec2007.dta" if seriescode=="NE.CON.GOVT.ZS", clear
for num 1960/2006: ren yearX govshareX
ren countrycode cty
drop seriesname seriescode countryname
reshape long govshare, i(cty) j(year)  
la var govshare "General government final consumption expenditure (% of GDP), Source: WDI"
sort cty year
save temp13, replace

use temp1.dta, clear
for num 2/13: merge cty year using tempX.dta \ drop _merge \ sort cty year
for num 0/13: erase tempX.dta
* Estimating each country's share of world GDP
gen temp1=population*gdp
gen temp2=temp1 if cty=="WLD"
bysort year: egen temp3=max(temp2)
gen gdpshare=temp1/temp3
tabstat gdpshare,by(cty)
drop temp*
drop if cty=="WLD"
sort cty year
save temp_mergedata.dta, replace

use "C:\Users\Andrew\Datasets\Polity IV\p4v2004.dta", clear
ren country countryc
* Note that the Polity IV 3-letter country codes are non-standard, so we need to match on country names
* the following code ensures that Polity IV country names are the same as Beck et al country names
* Bahamas, Barbados, Grenada, Iceland, Malta, Santa Lucia, Vanuatu, W.Samoa are missing from Polity IV (Iceland is listed in the codebook but not in the dataset - an error?)
* The first list are Polity IV names, the second list are Beck names
for any "United Kingdom" "Congo Kinshasa" "Czech Republic" "Dominican Rep." "Germany West" Germany "Papua New Guinea" "South Africa" "Trinidad" \ any UK Congo "Czech Rep." "Dom. Rep." "FRG/Germany" "FRG/Germany" "P. N. Guinea" "S. Africa" "Trinidad-Tobago": replace countryc="Y" if countryc=="X"
replace year=year+1
*Removing duplicate year observations. Alternative: drop if (scode=="YGS" & year==1991) | (scode=="ETI" & year==1993)
bysort countryc year: egen seq=seq()
drop if seq>=2
drop seq
sort countryc year
save temp_polity4, replace 

*/

* This starts with the Beck et al dataset, as downloaded from the World Bank site on Dec 31, 2003.
use beck.2003.asdownloaded.dta, clear
*keep countryc ifs year legelec exelec fraud prtyin 
keep countryc ifs year legelec exelec fraud prtyin maj percent1 percentl eiec tensys
ren ifs cty
sort countryc year
merge countryc year using "Van Belle-sorted.dta", nokeep
tab _merge
drop _merge

* Merging with WDI & Barro-Lee data
sort cty year
merge cty year using temp_mergedata.dta, update nokeep
drop _merge
for any radios tvs phones papers vehicles cars computers: replace X=X/1000
for any illiteracy: replace X=X/100
for any population gdp: replace X=ln(X)

* Merge with Polity IV
sort countryc year 
merge countryc year using temp_polity4, nokeep keep(polity2 durable)
drop _merge

sort year
merge year using "Oil prices (IMF).dta", update nokeep
drop _merge
rename averagecrudeprice oil
sort cty year
gen oecd18=1 if cty=="JPN" | cty=="NOR" | cty=="FRA" | cty=="IRE" | cty=="BEL" | cty=="FIN" | cty=="CHE" | cty=="ITA" | cty=="GBR" | cty=="DNK" | cty=="AUS" | cty=="NZL" | cty=="GER" | cty=="SWE" | cty=="CAN" | cty=="USA" | cty=="AUT" | cty=="NLD"
replace oecd18=0 if oecd~=1	
sort cty year
sort cty
merge cty using "Country numbers.dta", nokeep
drop _merge
sort cty
merge cty using "Region codes (from Penn WT).dta", update nokeep
drop _merge
* The next lines are necessary because the Penn WT region codes are incomplete.
replace region=9 if cty=="AFG"
replace region=13 if cty=="BIH"
replace region=10 if cty=="BRN"
replace region=5 if cty=="LBY"
replace region=8 if cty=="MDV"
replace region=12 if cty=="MMR"
replace region=10 if cty=="PRK"
replace region=15 if cty=="SLB"
replace region=13 if cty=="SUN"
replace region=15 if cty=="VUT"
replace region=15 if cty=="WSM"
replace region=5 if cty=="YMD"
replace region=13 if cty=="YSR"
label define reg1 1 "West Africa" 2 "Central Africa" 3 "East Africa" 4 "South Africa" 5 "North Africa & Middle East" 6 "North America" 7 "South America" 8 "Carribean" 9 "Central Asia" 10 "East Asia" 11 "Southeast Asia" 12 "Southwest Asia" 13 "Eastern Europe" 14 "Western Europe" 15 "Oceania"
label values region reg1
gen regionb=1 if region==1 | region==2 | region==3 | region==4 | region==5
replace regionb=2 if region==6 | region==7 | region==8
replace regionb=3 if region==9 | region==10 | region==11 | region==12 | region==15
replace regionb=4 if region==13 | region==14
label define reg2 1 "Africa & Middle East" 2 "Americas and the Caribbean" 3 "Asia & Oceania" 4 "Europe"
label values regionb reg2
gen decade=1970 if year<1980
replace decade=1980 if year>1979 & year<1990
replace decade=1990 if year>1989
* The Beck dataset contains figures for Yemen, Yemen (AR), and Yemen (PDR). However, 
* since none of them have more than one democratic election during this period, it 
* does not affect the results if they are dropped.
drop if cty=="YEM" | cty=="0" | ctyno==.

* Creating a measure of world growth that excludes the country
replace dyworld=dyworld-dy*gdpshare/(1-gdpshare)

* This drops the world's two largest economies, for whom world growth is not exogenous.
drop if cty=="JPN" | cty=="USA"

tsset ctyno year
gen legelecnf=legelec*(1-fraud)
gen exelecnf=exelec*(1-fraud)
gen reelect=0 if f.prtyin==1 
replace reelect=1 if f.prtyin>1 & f.prtyin~=.

gen elec0=max(legelecnf,exelecnf)
gen lelec1=L.legelecnf
gen eelec1=L.exelecnf
gen elec1=max(eelec1,lelec1)
gen lelec2=L2.legelecnf
gen eelec2=L2.exelecnf
gen elec2=max(eelec2,lelec2)
gen lelec3=L3.legelecnf
gen eelec3=L3.exelecnf
gen elec3=max(eelec3,lelec3)
gen lelec4=L4.legelecnf
gen eelec4=L4.exelecnf
gen elec4=max(eelec4,lelec4)
gen lelec5=L5.legelecnf
gen eelec5=L5.exelecnf
gen elec5=max(eelec5,lelec5)
gen dy1=L.dy
gen dy2=L2.dy
gen dy3=L3.dy
gen dy4=L4.dy
gen dyw1=L.dyworld
gen dyw2=L2.dyworld
gen dyw3=L3.dyworld
gen dyw4=L4.dyworld
gen dyo1=L.dyoecd
gen dyo2=L2.dyoecd
gen dyo3=L3.dyoecd
gen dyo4=L4.dyoecd

* If you had an election last year, relevant growth is this year only. If you had an 
* election 2 years ago, it's the average of this year and last year. Etc, etc.
gen dyterm=dy if elec1==1
replace dyterm=(dy+dy1)/2 if elec2==1 & dyterm==.
replace dyterm=(dy+dy1+dy2)/3 if elec3==1 & dyterm==.
replace dyterm=(dy+dy1+dy2+dy3)/4 if elec4==1 & dyterm==.
replace dyterm=(dy+dy1+dy2+dy3+dy4)/5 if elec5==1 & dyterm==.
replace dyterm=. if elec0~=1
gen dywterm=dyworld if elec1==1
replace dywterm=(dyworld+dyw1)/2 if elec2==1 & dywterm==.
replace dywterm=(dyworld+dyw1+dyw2)/3 if elec3==1 & dywterm==.
replace dywterm=(dyworld+dyw1+dyw2+dyw3)/4 if elec4==1 & dywterm==.
replace dywterm=(dyworld+dyw1+dyw2+dyw3+dyw4)/5 if elec5==1 & dywterm==.
replace dywterm=. if elec0~=1
gen dyoterm=dyoecd if elec1==1
replace dyoterm=(dyoecd+dyo1)/2 if elec2==1 & dyoterm==.
replace dyoterm=(dyoecd+dyo1+dyo2)/3 if elec3==1 & dyoterm==.
replace dyoterm=(dyoecd+dyo1+dyo2+dyo3)/4 if elec4==1 & dyoterm==.
replace dyoterm=(dyoecd+dyo1+dyo2+dyo3+dyo4)/5 if elec5==1 & dyoterm==.
replace dyoterm=. if elec0~=1

gen competence=dyterm-dywterm
gen luck=dywterm

* (1) MOST BASIC SPECIFICATION
xtset ctyno
xtlogit reelect dyterm if legelecnf==1 | exelecnf==1, fe
log using mfx, replace
mfx, var(dyterm) predict(pu0) 
mfx2, replace var(dyterm) predict(pu0) trustme
log close
outreg using table_logit.doc, coefastr se nocons 3aster bracket replace ct("Basic") bdec(3) addstat("R2",e(r2_p)) adec(2)
gen logitsample=e(sample)
xtreg reelect dyterm if logitsample==1, fe 
outreg using table_ols.doc, coefastr se nocons 3aster bracket replace ct("Basic") bdec(3)
tab country if logitsample==1

* AVERAGING DATA FOR EACH COUNTRY
* Since I am about to take the average for each country, I create another variable (suffix "_"), that contains time-varying country characteristics
* Then I interpolate over the whole term, and keep constant before & after that
for any gdp tyr15 papers radios tvs polity2 durable govshare: gen X_=X \ la var X_ "Time-varying X"
for any gdp tyr15 papers radios tvs polity2 durable govshare: bysort ctyno: ipolate X_ year, gen(temp) \ replace X_=temp if X_==. \ drop temp
tsset ctyno year
for any gdp tyr15 papers radios tvs polity2 durable govshare: replace X_=l.X_ if X_==.
for X in any gdp tyr15 papers radios tvs polity2 durable govshare: for Y in num 1/20: replace X_=f.X_ if X_==. & year~=Y

*Averaging over the whole term
for any gdp tyr15 papers radios tvs polity2 durable govshare: bysort ctyno: egen temp=mean(X) if year>1975 \ replace X=temp \ drop temp \ la var X "Time-invariant X"
* Imputing from same region if missing
for var papers tyr15 polity2 durable govshare: bysort region year: egen temp=mean(X) \ replace X=temp if X==. \ drop temp
for var papers tyr15 polity2 durable govshare: bysort region year: egen temp=mean(X_) \ replace X_=temp if X_==. \ drop temp

* SUMMARY STATISTICS
sum reelect dy dyworld gdp tyr15 polity2 durable govshare papers radios tvs if logitsample==1,sep(0) 

* Are clustered SEs necessary? Wooldridge test.
*sort cty year
*bysort cty: egen seq=seq() if logitsample==1
*tsset ctyno seq
*xtserial reelect luck competence 
*drop seq

* APPENDIX TABLE 1 (asterisk out when not creating this table)
*drop if logitsample~=1
*keep countryc year
*sort countryc year
*bysort countryc : egen seq=seq()
*for num 1/8: gen electionX=year if seq==X
*collapse election*, by(countryc )
*for num 1/8: tostring electionX, force replace \ replace electionX="" if electionX=="."
*gen elections=election1+", "+election2+", "+election3+", "+election4+", "+election5+", "+election6+", "+election7+", "+election8 
*drop election1-election8
*replace elections=subinstr(elections,", ,","",.)
*replace elections=subinstr(elections," ,","",.)
*browse

* GRAPH
set scheme s1mono
bysort year: egen pct_reelect=mean(reelect) if logitsample==1
egen temp=tag(year) if logitsample==1
gen tempdyworld=dyworld/100
twoway bar pct_reelect year if temp==1, c(l) yaxis(1) ylab(0(.2)1) ysc(r(0 1)) || line tempdyworld year if temp==1, c(l) yaxis(2) lcolor(black) lwidth(medthick) xtitle("") ytitle("Fraction of incumbents re-elected (bars)", axis(1)) ytitle("World GDP per capita growth rate (line)", axis(2))  ti("Figure 1: World Growth and National Elections") legend(off)
tabstat pct_reelect tempdyworld,by(year)
drop temp*

* What's the average election term?
gen termlength=1 if elec1==1
for num 2/5: replace termlength=X if elecX==1 & termlength==.
sum termlength if logitsample==1

* LUCK VS COMPETENCE
xtset ctyno
xtlogit reelect luck competence if legelecnf==1 | exelecnf==1, fe
log using mfx, append
mfx, var(luck competence) predict(pu0) 
mfx2, replace var(luck competence) predict(pu0) trustme
log close
outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("Assuming world growth has the same effect on all economies") bdec(3)  addstat("N",e(N),"R2",e(r2_p)) adec(3)
xtreg reelect luck competence if logitsample==1, fe
outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("Assuming world growth has the same effect on all economies") bdec(3)

* Robustness check - minimum 4 elections & 2 regime changes
bysort cty: egen count_elections=count(reelect) if logitsample==1
bysort cty: egen count_oustings=count(reelect) if logitsample==1 & reelect==0
qui xtlogit reelect luck competence if (legelecnf==1 | exelecnf==1) & count_elections>=4 & count_oustings>=2, fe
di "N="e(N) _ne "R2="e(r2_p)
codebook cty if e(sample)
mfx2, replace var(luck competence) predict(pu0) trustme

* Robustness check  - voteshare
gen voteshare=percentl/100 if reelect==1
replace voteshare=1-percentl/100 if reelect==0
replace voteshare=percent1/100 if reelect==1 & voteshare==.
replace voteshare=1-percent1/100 if reelect==0 & voteshare==.
replace voteshare=maj if reelect==1 & voteshare==.
replace voteshare=1-maj if reelect==0 & voteshare==.
bysort reelect: sum voteshare if logitsample==1
gen unfeasible=0
replace unfeasible=1 if voteshare>.5 & reelect==0
replace unfeasible=1 if voteshare<.5 & reelect==1
xtreg voteshare luck competence if logitsample==1 & unfeasible==0, fe

* OLS outlier check (note, this needs to be done with xi, not xtreg)
xi: reg reelect dyterm i.cty if logitsample==1 
predict reelect_hat if e(sample)
sum reelect_hat if (reelect_hat<0 | reelect_hat>1) & reelect_hat~=.
drop reelect_hat
rvpplot dyterm
xi: reg reelect luck competence i.cty if logitsample==1, 
predict reelect_hat if e(sample)
sum reelect_hat if (reelect_hat<0 | reelect_hat>1) & reelect_hat~=.
drop reelect_hat
rvpplot luck,mlabel(cty)
rvpplot competence,mlabel(cty)
xtreg reelect dyterm if logitsample==1 & cty~="TGO", fe
xtreg reelect luck competence if logitsample==1 & cty~="TGO", fe

* Luck vs Competence (using OECD growth)
gen competence_o=dyterm-dyoterm
gen luck_o=dyoterm
qui xtlogit reelect luck_o competence_o if legelecnf==1 | exelecnf==1, fe
mfx2, replace var(luck_o competence_o) predict(pu0) trustme
xtreg reelect luck_o competence_o if logitsample==1, fe

* TAKING ACCOUNT OF DIFFERENT DEGREES OF GLOBAL INTEGRATION
drop luck* competence*

* Checking the within-R2
bysort ctyno: egen lsample=max(logitsample)
levelsof ctyno if lsample==1, local(ctyno)
foreach c of local ctyno {
 gen dyworld_`c'=0
 replace dyworld_`c'=dyworld if ctyno==`c'
 }
xtset ctyno
xtreg dy dyworld_* if year>1974 & lsample==1,fe
drop dyworld_* lsample

xi: reg dy i.cty*dyworld if year>1974 ,
predict luck
predict se_prediction,stdp
bysort country: egen se_weight=mean(se_prediction) if logitsample==1
replace se_weight=1/(se_weight^2)
gen competence=dy-luck
tsset ctyno year
gen luck1=L.luck
gen luck2=L2.luck
gen luck3=L3.luck
gen luck4=L4.luck
gen comp1=L.competence
gen comp2=L2.competence
gen comp3=L3.competence
gen comp4=L4.competence
gen luckterm=luck if elec1==1
replace luckterm=(luck+luck1)/2 if elec2==1 & luckterm==.
replace luckterm=(luck+luck1+luck2)/3 if elec3==1 & luckterm==.
replace luckterm=(luck+luck1+luck2+luck3)/4 if elec4==1 & luckterm==.
replace luckterm=(luck+luck1+luck2+luck3+luck4)/5 if elec5==1 & luckterm==.
replace luckterm=. if elec0~=1
gen compterm=competence if elec1==1
replace compterm=(competence+comp1)/2 if elec2==1 & compterm==.
replace compterm=(competence+comp1+comp2)/3 if elec3==1 & compterm==.
replace compterm=(competence+comp1+comp2+comp3)/4 if elec4==1 & compterm==.
replace compterm=(competence+comp1+comp2+comp3+comp4)/5 if elec5==1 & compterm==.
replace compterm=. if elec0~=1

xtset ctyno
qui xtlogit reelect luckterm compterm if legelecnf==1 | exelecnf==1, fe 
di "N="e(N) _ne "R2="e(r2_p)
log using mfx, append
mfx, var(luckterm compterm ) predict(pu0) 
mfx2, replace var(luckterm compterm ) predict(pu0) trustme
log close
outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("Taking Account") bdec(3) addstat("N",e(N),"R2",e(r2_p)) adec(2)
xtreg reelect luckterm compterm if logitsample==1, fe
outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("Taking Account") bdec(3)

* Robustness check - minimum 4 elections & 2 regime changes
qui xtlogit reelect luckterm compterm if (legelecnf==1 | exelecnf==1) & count_elections>=4 & count_oustings>=2, fe 
di "N="e(N) _ne "R2="e(r2_p)
codebook cty if e(sample)
mfx2, replace var(luckterm compterm) predict(pu0) trustme

* Robustness check - weighting by the inverse of the variance on the prediction 
qui xtlogit reelect luckterm compterm if (legelecnf==1 | exelecnf==1) [iw=se_weight], 
di "N="e(N) _ne "R2="e(r2_p)
codebook cty if e(sample)
mfx2, replace var(luckterm compterm ) predict(pu0) trustme
xtreg reelect luckterm compterm if logitsample==1, fe
xtreg reelect luckterm compterm if logitsample==1 [aw=se_weight], fe 

* INTERACTIONS
* Is multicollinearity a problem?
pwcorr gdp tyr15 polity2 durable govshare papers radios tvs  if logitsample==1,
* Standardizing to mean 0, SD 1
for any gdp tyr15 papers radios tvs polity2 durable govshare : egen temp=std(X) if logitsample \ replace X=temp \ drop temp
gen media3=papers+radios+tvs
for var papers tvs radios media3 tyr15 gdp polity2 durable govshare : gen l_X=luckterm*X \ gen c_X=compterm*X 
xtset ctyno
qui xtlogit reelect luckterm compterm l_gdp c_gdp if legelecnf==1 | exelecnf==1, fe  
log using mfx, append
mfx, var(luckterm compterm l_gdp c_gdp ) predict(pu0) 
mfx2, replace var(luckterm compterm l_gdp c_gdp) predict(pu0) trustme
log close
testparm l_* c_*
outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("GDP") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3)


*di "N="e(N) _ne "R2="e(r2_p)
for var tyr15: qui xtlogit reelect luckterm compterm c_X l_X if legelecnf==1 | exelecnf==1, fe \ log using mfx, append \ mfx, var(luckterm compterm c_X l_X) predict(pu0) \ mfx2, replace var(luckterm compterm c_X l_X) predict(pu0) trustme \ log close \ testparm l_* c_* \ outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("Ed") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3) \ di "N="e(N) _ne "R2="e(r2_p) 
for var tyr15: qui xtlogit reelect luckterm compterm l_X c_X l_gdp c_gdp if legelecnf==1 | exelecnf==1, fe \ log using mfx, append \ mfx, var(luckterm compterm l_X c_X l_gdp c_gdp) predict(pu0) \ mfx2, replace var(luckterm compterm l_X c_X l_gdp c_gdp) predict(pu0) trustme \ log close \ testparm l_* c_* \ outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("GDP&Ed") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3) \ di "N="e(N) _ne "R2="e(r2_p) 
for var polity2 durable govshare papers radios tvs media3: qui xtlogit reelect luckterm compterm l_X c_X l_gdp c_gdp if legelecnf==1 | exelecnf==1, fe \ log using mfx, append \ mfx, var(luckterm compterm l_X c_X l_gdp c_gdp) predict(pu0) \ mfx2, replace var(luckterm compterm l_X c_X l_gdp c_gdp) predict(pu0) trustme \ log close \ testparm l_* c_* \ outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("X") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3) \ di "N="e(N) _ne "R2="e(r2_p) 
qui xtreg reelect luckterm compterm l_gdp c_gdp if logitsample==1, fe
testparm l_* c_* 
outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("GDP") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)

for var tyr15: qui xtreg reelect luckterm compterm c_X l_X if logitsample==1, fe \ testparm l_* c_* \ outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("Ed") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
for var tyr15: qui xtreg reelect luckterm compterm c_X c_gdp l_X l_gdp if logitsample==1, fe \ testparm l_* c_* \ outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("GDP&Ed") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
for var polity2 durable govshare papers radios tvs media3: qui xtreg reelect luckterm compterm l_X c_X l_gdp c_gdp if logitsample==1, fe \ testparm l_* c_* \ outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("X") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
* Outlier check
for any tvs: qui xi: reg reelect luckterm compterm l_X c_X l_gdp c_gdp i.cty if logitsample==1, 
predict reelect_hat if e(sample)
sum reelect_hat if (reelect_hat<0 | reelect_hat>1) & reelect_hat~=.
drop reelect_hat

* Interactions - ignoring the luck/competence issue, does the economy matter more in more developed nations?
for any gdp tyr15: gen dyterm_X=dyterm*X 
for any gdp tyr15: xtreg reelect dyterm dyterm_X if logitsample==1, fe 

* ROBUSTNESS CHECK ON INTERACTIONS
* Split the sample on the governance measures
for var polity2 durable govshare : xtreg reelect luckterm compterm if logitsample==1 & X>0, fe \ xtreg reelect luckterm compterm if logitsample==1 & X<=0, fe

* Using time-varying interaction characteristics
for any gdp tyr15 papers radios tvs polity2 durable govshare : egen temp=std(X_) if logitsample \ replace X_=temp \ drop temp
for var papers tvs radios tyr15 gdp polity2 durable govshare : replace l_X=luckterm*X_ \ replace c_X=compterm*X_ 
qui xtlogit reelect luckterm compterm l_gdp c_gdp gdp_ if legelecnf==1 | exelecnf==1, fe 
mfx2, replace var(luckterm compterm l_gdp c_gdp gdp_) predict(pu0) trustme
testparm l_* c_*
outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("GDP-timevarying") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3)
for var tyr15: qui xtlogit reelect luckterm compterm c_X l_X X_ if legelecnf==1 | exelecnf==1, fe \ mfx2, replace var(luckterm compterm c_X l_X X_) predict(pu0) trustme \ testparm l_* c_* \ outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("Ed-timevarying") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3) \ di "N="e(N) _ne "R2="e(r2_p) 
for var tyr15: qui xtlogit reelect luckterm compterm c_X c_gdp l_X l_gdp gdp_ X_ if legelecnf==1 | exelecnf==1, fe \ mfx2, replace var(luckterm compterm l_gdp c_gdp l_X c_X gdp_ X_) predict(pu0) trustme \ testparm l_* c_* \ outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("GDP&Ed-timevarying") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3) \ di "N="e(N) _ne "R2="e(r2_p) 
for var polity2 durable govshare papers radios tvs : qui xtlogit reelect luckterm compterm l_X c_X l_gdp c_gdp gdp_ X_ if legelecnf==1 | exelecnf==1, fe  \ mfx2, replace var(luckterm compterm l_X c_X l_gdp c_gdp gdp_ X_) predict(pu0) trustme \ testparm l_* c_* \ outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("X-timevarying") bdec(3) addstat("N",e(N),"R2",e(r2_p),"chi2-test",r(chi2),"F(pval)",r(p)) adec(3) \ di "N="e(N) _ne "R2="e(r2_p) 
qui xtreg reelect luckterm compterm l_gdp c_gdp gdp_ if logitsample==1, fe
testparm l_* c_* 
outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("GDP-timevarying") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
for var tyr15: qui xtreg reelect luckterm compterm c_X l_X X_ if logitsample==1, fe \ testparm l_* c_* \ outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("Ed-timevarying") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
for var tyr15: qui xtreg reelect luckterm compterm c_X c_gdp l_X l_gdp gdp_ X_ if logitsample==1, fe \ testparm l_* c_* \ outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("GDP&Ed-timevarying") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
for var polity2 durable govshare papers radios tvs : qui xtreg reelect luckterm compterm l_X c_X l_gdp c_gdp gdp_ X_ if logitsample==1, fe \ testparm l_* c_* \ outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("X-timevarying") bdec(3) addstat("F-test",r(F),"F(pval)",r(p)) adec(3)
STOP

*gen agedemocracy=tensys if eiec==6 | eiec==7
*sum agedemocracy if logitsample==1
*gen democracyindex=eiec
*split into 6/7
* EIEC: multiple parties are legal but  		   only one party won seats:	5 
* multiple parties DID win  		   seats but the largest party    received more than 75% of    the seats:		 	6
* largest party got less than 75%:	7
*qui xi: logit reelect luck competence i.cty if (legelecnf==1 | exelecnf==1) & democracyindex==7,  
*di "N="e(N) _ne "R2="e(r2_p)
*codebook cty if e(sample)
*mfx2, replace var(luck competence)
*qui xi: logit reelect luck competence i.cty if (legelecnf==1 | exelecnf==1) & democracyindex<=6, 
*di "N="e(N) _ne "R2="e(r2_p)
*codebook cty if e(sample)
*mfx2, replace var(luck competence)





* OIL MODEL 
sort cty
merge cty using "Energy imports 1971.dta", update
drop if _merge<3
drop _merge
sort year
merge year using "US CPI-U & changes in oil prices.dta", update
drop if _merge<3
drop _merge
*sort cty year
*merge cty year using "Energy imports 1961-2000.dta", update
*drop _merge
tsset ctyno year, yearly
gen doil1=L.doil
gen doil2=L2.doil
gen doil3=L3.doil
gen doil4=L4.doil
gen doilterm=doil if elec1==1
replace doilterm=(doil+doil1)/2 if elec2==1 & doilterm==.
replace doilterm=(doil+doil1+doil2)/3 if elec3==1 & doilterm==.
replace doilterm=(doil+doil1+doil2+doil3)/4 if elec4==1 & doilterm==.
replace doilterm=(doil+doil1+doil2+doil3+doil4)/5 if elec5==1 & doilterm==.
replace doilterm=. if elec0~=1
xtset ctyno
xtlogit reelect doilterm if logitsample==1, fe
mfx2, replace var(doilterm) predict(pu0) trustme 
outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("Oil - full sample") bdec(3) addstat("N",e(N),"R2",e(r2_p)) adec(3)
xtlogit reelect doilterm if logitsample==1 & energyimports>0, fe
mfx2, replace var(doilterm) predict(pu0) trustme 
outreg using table_logit.doc, coefastr se nocons 3aster append bracket ct("Oil - importers only") bdec(3) addstat("N",e(N),"R2",e(r2_p)) adec(3)
xtreg reelect doilterm if logitsample==1, fe
outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("Oil - full sample") bdec(3) 
xtreg reelect doilterm if logitsample==1 & energyimports>0, fe
outreg using table_ols.doc, coefastr se nocons 3aster append bracket ct("Oil - importers only") bdec(3) 

* For summary statistics
sum doil if logitsample==1

STOP
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

* NOTES
* To input WDI data, use reshape long dy, i(cty) j(year)  

* INTEREST RATES MODEL [Probably not worth presenting]
sort year
merge year using "US interest rates.dta", update
xi: reg reelect federalfunds i.cty if legelecnf==1 | exelecnf==1, 

* IS OPENNESS DRIVING THIS? [Probably not worth presenting]
sort cty year
merge cty year using "Openness (from Penn WT).dta", update
drop _merge
label variable openk "Openness in constant prices"
gen open_luck=openk*luck
gen open_competence=openk*competence
xi: reg reelect luck competence openk open_l open_c i.cty if legelecnf==1 | exelecnf==1, 

* COUNTRY-BY-COUNTRY [Probably not worth presenting]
bysort cty: reg reelect dyterm dywterm if (legelecnf==1 | exelecnf==1) & oecd==1, 

* ADDING IN THE FIRST ELECTIONS
* In the term coding, we miss the first election, since the term is unclear. 
* This procedure adds the first elections back in (you might present both specifications)
replace dyterm=dy if (legelecnf==1 | exelecnf==1) & dy~=. & dyterm==.
replace dywterm=dyworld if (legelecnf==1 | exelecnf==1) & dyworld~=. & dywterm==.
xi: reg reelect dyterm dywterm i.cty if legelecnf==1 | exelecnf==1, 
xi: reg reelect dyterm dywterm i.cty if (legelecnf==1 | exelecnf==1) & oecd==1, 
xi: reg reelect dyterm dywterm i.cty if (legelecnf==1 | exelecnf==1) & oecd==0, 

* Time series option
* iis cty
* tis year
* xtreg  depvar [varlist] [if exp], fe [ i(varname) wls level(#) ]

* A BAD WAY OF DOING VOTESHARE CODING (SINCE VOTESHARE ALWAYS CODES THE WINNER, AND 
* GOES DOWN IF MORE PARTIES RUN):
* If it's a Presidential system, we want PERCENTL (final round vote for Prez) or 
* PERCENT1 (first/only round vote for Prez). If a parliamentary system, we want
* MAJ (which is equal to (numgov/(numul+numopp+numgov))
* gen votep=percentl if system==0 | system==1
* replace votep=percent1 if votep==.
* replace votep=(numgov/(numul+numopp+numgov)) if vote==. 
* gen votey=1 if exelec==1 & (system==0 | system==1)
* replace votey=1 if legelec==1 & system==2
* replace votey=0 if votey~=1

